/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize
#define iMouse vec4(vec2(u_WindowSize)/4.0, 0.0,0.0)

/////////////////////////////////////////////////////////////////////////////////

// With VGHD the range of the P argument's components of the texture functions is
// 0.0 to 1.0 whereas with ShaderToy it seems that the upper limits are given  by
// the number of pixels in each direction, typically 512 or 64.  We therefore use
// the following functions instead.

vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}

// Rather than edit the body of the original shader we use use a define  here  to
// redirect texture calls to the above functions.

#define texture2D texture2D_Fract

/////////////////////////////////////////////////////////////////////////////////

// The ShaderToy shaders often use textures as inputs named iChannel0. With VGHD
// this may access a Sprite, ClipSprite or ClipNameSprite image depending on how
// the .scn file declares them.
//
// Note, the name used here does not seem to make any difference, so I have used
// iChannel0 which is what is used by ShaderToy but you can use any name as long
// as it matches the use in the main body of the shader. TheEmu.

uniform sampler2D iChannel0;

/////////////////////////////////////////////////////////////////////////////////

#define time iGlobalTime*.05

#define width .2

float thick=0.;
float pix;
float zoom = .5;


float formula(vec2 z) {
	float ot=1000.;
	for (int i=0; i<11; i++) {
		float dz=dot(z,z);
		z=abs(z*2.)/dz-1.;
		ot=min(ot,dz);
	}
	float h=.014/(max(0.,width-ot)/width*.9+.1);
	thick+=max(0.,1.-h);
	return h;
}

vec3 normal(vec2 z) {
	vec2 d=vec2(pix,0.);
	vec3 n=normalize(cross( //get normal
	vec3(d.x*2.,0.,formula(z-d.xy)-formula(z+d.xy)),
	vec3(0.,d.x*2.,formula(z-d.yx)-formula(z+d.yx))));
	return n;
}


void main(void)
{
	vec2 pos = gl_FragCoord.xy / iResolution.xy;
	vec2 uv=pos-.5;
	uv.x*=iResolution.x/iResolution.y;
	zoom*=1.+sin(time*2.)*.5;
	vec2 luv=uv;
	uv+=vec2(sin(time),cos(time))*2.;
	uv+=sin(uv*30.+time*200.)*.0015;
	uv*=zoom;
	luv*=zoom;
	pix=1./iResolution.x*zoom;
	vec2 d=vec2(pix,0.);
	vec3 n= normal(uv-d.xy)+normal(uv+d.xy);
	     n+=normal(uv-d.yx)+normal(uv+d.yx);
		 n/=4.;
	thick/=16.;
	vec2 refr=-n.xy*.08;
	vec3 tex=texture2D(iChannel0,((uv+refr)*3.+vec2(time,0.))).xyz+.75;
	vec3 colo=tex*mix(vec3(.35,.55,1.)*2.5,vec3(1.,.65,.15)*.25,sqrt(thick));	
	vec3 lightdir=normalize(vec3(1.,.5,2.));
	colo+=max(0.,dot(-n,lightdir))*.4;
	colo+=pow(max(0.,dot(reflect(-n,vec3(0.,0.,-1.)),lightdir)),50.)*.6;
	colo+=pow(max(0.,dot(reflect(vec3(0.,0.,-1.),-n),lightdir)),50.)*.2;
	colo=pow(colo,vec3(1.5))*2.;
	gl_FragColor = vec4(colo,1.0);
}